/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client;

import ht.treechop.client.Client;
import ht.treechop.client.gui.screen.ClientSettingsScreen;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class KeyBindings {
    public static final String CATEGORY = "HT's TreeChop";
    public static final List<ActionableKeyBinding> allKeyBindings = new LinkedList<ActionableKeyBinding>();

    public static void init() {
        KeyBindings.registerKeyBinding("toggle_chopping", KeyBindings.getKey(-1), Client::toggleChopping);
        KeyBindings.registerKeyBinding("toggle_felling", KeyBindings.getKey(-1), Client::toggleFelling);
        KeyBindings.registerKeyBinding("cycle_sneak_behavior", KeyBindings.getKey(-1), Client::cycleSneakBehavior);
        KeyBindings.registerKeyBinding("open_settings_overlay", KeyBindings.getKey(78), Client::toggleSettingsOverlay);
    }

    private static ActionableKeyBinding registerKeyBinding(String name, InputMappings.Input defaultKey, Runnable callback) {
        ActionableKeyBinding keyBinding = new ActionableKeyBinding(String.format("%s.key.%s", "treechop", name), defaultKey, callback);
        ClientRegistry.registerKeyBinding((KeyBinding)keyBinding);
        allKeyBindings.add(keyBinding);
        return keyBinding;
    }

    static InputMappings.Input getKey(int key) {
        return InputMappings.Type.KEYSYM.func_197944_a(key);
    }

    public static void buttonPressed(int keyCode, int keyState) {
        for (ActionableKeyBinding keyBinding : allKeyBindings) {
            if (keyCode != keyBinding.getKey().func_197937_c() || keyState != 1) continue;
            keyBinding.onPress();
            return;
        }
    }

    protected static class ActionableKeyBinding
    extends KeyBinding {
        private final Runnable callback = () -> {
            Screen screen = Minecraft.func_71410_x().field_71462_r;
            if (screen == null || screen instanceof ClientSettingsScreen) {
                callback.run();
            }
        };

        public ActionableKeyBinding(String resourceName, InputMappings.Input inputByCode, Runnable callback) {
            super(resourceName, (IKeyConflictContext)KeyConflictContext.GUI, inputByCode, KeyBindings.CATEGORY);
        }

        public void onPress() {
            this.callback.run();
        }
    }
}

